package de.hdm_stuttgart.mi.sd1.task1;

import de.hdm_stuttgart.mi.exam.unitmarking.ExaminationTestDefaults;
import de.hdm_stuttgart.mi.exam.unitmarking.Points;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

/**
 * <p>Array methods.</p>
 *
 */
public class TestArrayHelper extends ExaminationTestDefaults {

    @Test
    @Order(20)
    @Points(10)
    public void testCreate() {
        Assertions.assertArrayEquals(
                new String[]{"flex4", "flex5", "flex6", "flex7"},
                ArrayHelper.create("flex", 4, 7));
        Assertions.assertArrayEquals(
                new String[]{"plow99","plow100", "plow101", "plow102", "plow103",},
                ArrayHelper.create("plow", 99, 103));
    }


    @Test
    @Order(200)
    @Points(4)
    public void testEmptyNull() {
        Assertions.assertArrayEquals(new String[]{}, ArrayHelper.stripNulls(new String[]{}));
        Assertions.assertArrayEquals(new String[]{}, ArrayHelper.stripNulls(new String[]{null}));
        Assertions.assertArrayEquals(new String[]{}, ArrayHelper.stripNulls(new String[]{null, null}));
    }
    @Test
    @Order(220)
    @Points(4)
    public void testNullFree() {
        Assertions.assertArrayEquals(new String[]{"thunder"}, ArrayHelper.stripNulls(new String[]{"thunder"}));
        Assertions.assertArrayEquals(new String[]{"a", "bc"}, ArrayHelper.stripNulls(new String[]{"a", "bc"}));
        Assertions.assertArrayEquals(
                new String[]{"a", "bc", "1234"},
                ArrayHelper.stripNulls(new String[]{"a", "bc", "1234"}));
    }

    @Test
    @Order(240)
    @Points(2)
    public void testMixed() {
        Assertions.assertArrayEquals(new String[]{"grey"}, ArrayHelper.stripNulls(new String[]{"grey", null}));

        Assertions.assertArrayEquals(
                new String[]{"x", "pest"},
                ArrayHelper.stripNulls(new String[]{null, "x", "pest", null}));

        Assertions.assertArrayEquals(
                new String[]{"This", "is", "my", "last", "test"},
                ArrayHelper.stripNulls(new String[]{"This", "is", "my", "last", "test"}));

        Assertions.assertArrayEquals(
                new String[]{"This", "is", "my", "last", "test"},
                ArrayHelper.stripNulls(new String[]{"This", "is", "my", "last", "test", null}));

        Assertions.assertArrayEquals(
                new String[]{"This", "is", "my", "last", "test"},
                ArrayHelper.stripNulls(new String[]
                        {null, null, "This", "is", null, null, "my", "last", "test", null}));
    }

}
