package de.hdm_stuttgart.mi.sd1.task2;

/**
 * Rectangle operations
 */
public class Rectangle {

  final Point leftLowerCorner;

  final double width;
  final double height;

  /**
   * Creating a rectangle by its left lower corner, width and height.
   *
   * @param leftLowerCorner The rectangle's left lower corner.
   * @param width The rectangle's width;
   * @param height The rectangle's height.
   */
  public Rectangle(final Point leftLowerCorner, final double width, final double height) {
    this.leftLowerCorner = leftLowerCorner;
    this.width = width;
    this.height = height;
  }

  /**
   *
   * <p>Check for a point being located inside the rectangle including its borders.</p>
   *
   * <p>The following example shows a rectangle having lower left corner coordinates (3|4), width 7 and height 3:</p>
   *
   * <img src="doc-files/contained.svg" alt="A rectangle, one point inside and one outside" width="300">
   *
   * <p>With respect to this rectangle:</p>
   *
   *    <ul>
   *        <li>Point (9|5) is being contained.</li>
   *        <li>Point (10|9) is located outside.</li>
   *    </ul>
   *
   * @param point A point.
   * @return <code>true</code>, if point is contained by the rectangle, <code>false</code> otherwise.
   */
  public boolean contains(final Point point) {
    return leftLowerCorner.x <= point.x && point.x <= leftLowerCorner.x + width &&
            leftLowerCorner.y <= point.y && point.y <= leftLowerCorner.y + height;
  }
}
