package de.hdm_stuttgart.mi.sd1.task2;

import de.hdm_stuttgart.mi.exam.unitmarking.ExaminationTestDefaults;
import de.hdm_stuttgart.mi.exam.unitmarking.Points;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

import static de.hdm_stuttgart.mi.sd1.task2.PathValidity.*;

public class UnlockPatternTest extends ExaminationTestDefaults {

    @Test @Order(100) @Points(7)
    public void testToString() {

        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{0, 1, 2, 5});
            Assertions.assertEquals("{0,1,2,5}", pattern.toString());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{0, 1, 2, 5});
            Assertions.assertEquals("{0,1,2,5}", pattern.toString());
        }
    }

    @Test @Order(110)
    public void testToStringModify() {

        final byte[] SWIPE_PATH = {7, 6, 4, 0};
        final UnlockPattern pattern = new UnlockPattern(SWIPE_PATH);
        Assertions.assertEquals("{7,6,4,0}", pattern.toString());

        // Modify the original array: This should not affect the already created instance
        SWIPE_PATH[0] = 0;
        Assertions.assertEquals("{7,6,4,0}", pattern.toString(),
                "Your instance can be modified by changing the constructor argument array's values!");
    }

    @Test @Order(150) @Points(2)
    public void testEquals() {
        {
            final UnlockPattern
                    p_6a = new UnlockPattern(new byte[]{6}),
                    p_6b = new UnlockPattern(new byte[]{6}),
                    p_2 = new UnlockPattern(new byte[]{2}),
                    p_0_1_2_5a = new UnlockPattern(new byte[]{0, 1, 2, 5}),
                    p_0_1_2_5b = new UnlockPattern(new byte[]{0, 1, 2, 5}),
                    p_5_4_1 = new UnlockPattern(new byte[]{5, 4, 1})
            ;
            Assertions.assertEquals(p_6a, p_6a);
            Assertions.assertEquals(p_6a, p_6b);
            Assertions.assertEquals(p_6b, p_6a);

            Assertions.assertEquals(p_0_1_2_5a, p_0_1_2_5a);
            Assertions.assertEquals(p_0_1_2_5a, p_0_1_2_5b);
            Assertions.assertEquals(p_0_1_2_5b, p_0_1_2_5a);

            Assertions.assertNotEquals(p_6a, p_2);
            Assertions.assertNotEquals(p_0_1_2_5a, p_5_4_1);
            Assertions.assertFalse(p_0_1_2_5a.equals("Anton"));
            Assertions.assertNotEquals(p_6a, p_5_4_1);
        }
    }

    @Test @Order(200) @Points(5)
    public void testEmpty() {
        final UnlockPattern pattern = new UnlockPattern(new byte[]{});
        Assertions.assertEquals(EMPTY, pattern.isValid());
    }
    @Test @Order(210)  @Points(2)
    public void testValid() {
        {
            for (byte b = 0; b < 9; b++) {
                final UnlockPattern pattern = new UnlockPattern(new byte[]{b});
                Assertions.assertEquals(VALID, pattern.isValid());
            }
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{1, 2});
            Assertions.assertEquals(VALID, pattern.isValid());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{1, 2, 4, 3});
            Assertions.assertEquals(VALID, pattern.isValid());
        }
    }
    @Test @Order(220)
    public void testGap() {
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{2, 1, 4});
            Assertions.assertEquals(VALID, pattern.isValid());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{0, 2, 6, 8});
            Assertions.assertEquals(GAP, pattern.isValid());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{0, 1, 7});
            Assertions.assertEquals(GAP, pattern.isValid());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{2, 8});
            Assertions.assertEquals(GAP, pattern.isValid());
        }
    }
    @Test @Order(240)
    public void testDuplicate() {
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{1,2,2,5});
            Assertions.assertEquals(DUPLICATE, pattern.isValid());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{8, 7, 4, 4, 1});
            Assertions.assertEquals(DUPLICATE, pattern.isValid());
        }
    }
    @Test @Order(260)
    public void testErrorPriority() {
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{4, 5, 8});
            Assertions.assertEquals(VALID, pattern.isValid());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{8, 2, 2, 5});
            Assertions.assertEquals(GAP, pattern.isValid());
        }
        {
            final UnlockPattern pattern = new UnlockPattern(new byte[]{8, 7, 7, 0, 2});
            Assertions.assertEquals(DUPLICATE, pattern.isValid());
        }
    }
}
