package de.hdm_stuttgart.mi.sd1.task1;

import de.hdm_stuttgart.mi.exam.unitmarking.ExaminationTestDefaults;
import de.hdm_stuttgart.mi.exam.unitmarking.Points;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

public class StringHelperTest extends ExaminationTestDefaults {

    @Order(10) @Points(16) @Test
    public void testGermanUk() {
        assertSymmetric("", "");
        assertSymmetric("2578", "2578");
        assertSymmetric("100,50", "100.50");
        assertSymmetric("2343.3321", "2343,3321");
        assertSymmetric("21.123.119", "21,123,119");
        assertSymmetric("324.234,67", "324,234.67");
        assertSymmetric("0,33", "0.33");
    }


    private static void assertSymmetric(final String de, final String uk){
        Assertions.assertEquals(de, StringHelper.switchDecimal(uk), "»" + uk + "« should be turned into »" + de + "«");
        Assertions.assertEquals(uk, StringHelper.switchDecimal(de), "»" + de + "« should be turned into »" + uk + "«");
    }
}
