package de.hdm_stuttgart.mi.sd1.task1;

import de.hdm_stuttgart.mi.exam.unitmarking.ExaminationTestDefaults;
import de.hdm_stuttgart.mi.exam.unitmarking.Points;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

public class ArraySelectTest extends ExaminationTestDefaults {

    @Test @Order(10)
    public void testNull() {
        Assertions.assertArrayEquals(new int[]{}, ArraySelect.select(true, null));
        Assertions.assertArrayEquals(new int[]{}, ArraySelect.select(false, null));
    }
    @Test @Order(15) @Points(2)
    public void testEmpty() {
        Assertions.assertArrayEquals(new int[]{}, ArraySelect.select(true, new int[]{}));
        Assertions.assertArrayEquals(new int[]{}, ArraySelect.select(false, new int[]{}));
    }
    @Test @Order(20) @Points(2)
    public void testOne() {
        Assertions.assertArrayEquals(new int[]{7}, ArraySelect.select(true, new int[]{7}));
        Assertions.assertArrayEquals(new int[]{} , ArraySelect.select(false, new int[]{23}));
    }
    @Test @Order(30) @Points(2)
    public void testTwo() {
        Assertions.assertArrayEquals(new int[]{9}, ArraySelect.select(true, new int[]{9, 3}));
        Assertions.assertArrayEquals(new int[]{4}, ArraySelect.select(false, new int[]{7, 4}));
    }
    @Test @Order(40)
    public void testThree() {
        Assertions.assertArrayEquals(new int[]{9, 0}, ArraySelect.select(true, new int[]{9, 3, 0}));
        Assertions.assertArrayEquals(new int[]{7}   , ArraySelect.select(false, new int[]{1, 7, 4}));
    }
    @Test @Order(50)
    public void testFour() {
        Assertions.assertArrayEquals(new int[]{1, 2}, ArraySelect.select(true, new int[]{1, 3, 2, 9}));
        Assertions.assertArrayEquals(new int[]{7, 8}, ArraySelect.select(false, new int[]{5, 7, 2, 8}));
    }
    @Test @Order(60)
    public void testMulti() {
        Assertions.assertArrayEquals(
                new int[]{0, 2, -4, 9},
                ArraySelect.select(true, new int[]{0, 9, 2, 9, -4, 2, 9})
        );
        Assertions.assertArrayEquals(
                new int[]{9, 9, 2},
                ArraySelect.select(false, new int[]{0, 9, 2, 9, -4, 2, 9})
        );
        Assertions.assertArrayEquals(
                new int[]{22, 0, 3, 5, 1},
                ArraySelect.select(true, new int[]{22, 4, 0, 72, 3, 9, 5, 9, 1, -3})
        );
        Assertions.assertArrayEquals(
                new int[]{4, 72, 9, 9, -3},
                ArraySelect.select(false, new int[]{22, 4, 0, 72, 3, 9, 5, 9, 1, -3})
        );
    }
}
