package de.hdm_stuttgart.mi.sd1.task2;

/**
 * <p>Enum representing the validity of a swipe path in a mobile phone unlock pattern.</p>
 *
 * PathValidity describes a swipe path's  integrity with respect to constraints
 * like e.g., having no gaps or duplicate neighboring nodes.
 */
public enum PathValidity {
    /**
     * <p>Represents a valid swipe path.</p>
     *
     * This value indicates that the evaluated path adheres to all rules and constraints for a valid unlocking pattern.
     * It implies there are no duplicate nodes, no gaps, at least one node and all transitions are between direct
     * neighbors.
     */
    VALID,

    /**
     * <p>Represents an invalid state due to a path not containing any node.</p>
     */
    EMPTY,
    /**
     * <p>Represents an invalid state where a gap exists.</p>
     *
     * This value indicates that the evaluated path contains at least two nodes immediately following one another that
     * are not directly connected as neighbors, disrupting the continuity of the unlocking pattern.
     */
    GAP,

    /**
     * <p>Represents an invalid state caused by the presence of immediate neighboring duplicate nodes.</p>
     */
    DUPLICATE
}
