package de.hdm_stuttgart.mi.sd1.task1;

/**
 * String related helper class
 */
public class StringSwap {

    /**
     * <p>Swaps the contents of two {@link StringBuilder} instances.</p>
     *
     * <table class="goikTableDefaults">
     *     <caption>Example swapping two {@link StringBuilder} instance's values.</caption>
     *     <tr>
     *         <th>Code</th>
     *         <th>Result</th>
     *     </tr>
     *     <tr>
     *         <td><pre><code class="java"
     *             > final StringBuilder
     *<!--       -->    <span class="myRed">s1 = new StringBuilder("Hey")</span>,
     *<!--       -->    <span class="myGreen">s2 = new StringBuilder("Jude")</span>;
     *
     *<!--       --> StringSwap.swap(<span class="myRed">s1</span>, <span class="myGreen">s2</span>);
     *
     *<!--       --> System.out.println("s1 = " + s1);
     *<!--       --> System.out.println("s2 = " + s2);</code></pre></td>
     *
     *         <td><pre
     *             > s1 = Jude
     * <!--      -->s2 = Hey</pre></td>
     *     </tr>
     * </table>
     *
     * @param first The first string
     * @param second The second string
     *
     * <br>
     *
     * <section class="implementationHints">
     *    <h4>Hints:</h4>
     *
     *    <ol>
     *       <li>
     *          <p>Swapping two primitive types <code>a</code> and <code>b</code> works like:</p>
     *
     *          <pre
     *             >tmp = a;
     *<!--       -->a   = b;
     *<!--       -->b   = tmp;</pre>
     *          <p>Reference types require replacing the assignment operator by appropriate method calls.</p>
     *       </li>
     *       <li>
     *          <p>Useful methods:</p>
     *          <ul>
     *             <li>{@link StringBuilder#replace(int, int, String)}</li>
     *             <li>{@link StringBuilder#toString()}</li>
     *             <li>{@link StringBuilder#setLength(int)}, 0 allows for setting to empty</li>
     *             <li>{@link StringBuilder#delete(int, int)}</li>
     *             <li>{@link StringBuilder#append(String)}</li>
     *             <li>{@link StringBuilder#StringBuilder(String)}</li>
     *          </ul>
     *       </li>
     *    </ol>
     * </section>
     */
    public static void swap(final StringBuilder first, final StringBuilder second) {
        final String tmp = first.toString();
        first.replace(0, first.length(), second.toString());
        second.replace(0, second.length(), tmp);
    }

    private StringSwap() {/* Ignore me: My sole purpose is suppressing default constructor javadoc warnings */}
}
