package de.hdm_stuttgart.mi.sd1.task1;

/**
 * A helper class dealing with strings.
 */
public class StringHelper {
    /**
     * <p>Switching Anglo-American value representation to German and back.</p>
     *
     * <p>German and anglo-american numerical value representations differ:</p>
     *
     *
     * <pre
     *       >Germany: 14<span class="myRed"  ><b>.</b></span>345<span class="myRed"><b>.</b></span>123<span class="myGreen"><b>,</b></span>28
     *<!-- -->           <!--               --><b>🡙</b><!--                    -->   <b>🡙</b><!--                      -->   <b>🡙</b>
     *<!-- -->UK / US: 14<span class="myGreen"><b>,</b></span>345<span class="myGreen"><b>,</b></span>123<span class="myRed"><b>.</b></span>28</pre>
     *
     * <p>Thus, <span class="myRed">dot '.'</span> and <span class="myGreen">comma ','</span> are being exchanged:</p>
     *
     *
     * <table class="goikTableDefaults">
     *     <caption>Sample German 🢂 Angloamerican 🢂 German</caption>
     *     <tr>
     *         <th>Code</th>
     *         <th>Result</th>
     *     </tr>
     *     <tr>
     *         <td><pre><code class="java"
     *             >final String german = "14.345.123,28";
     *<!--       -->final String anglo = StringHelper.switchDecimal(german);
     *<!--       -->System.out.println(anglo);
     *<!--       -->final String backToGerman = StringHelper.switchDecimal(anglo);
     *<!--       -->System.out.println(backToGerman);</code></pre></td>
     *         <td><pre
     *             >14,345,123.28
     *<!--       -->14.345.123,28</pre></td>
     *     </tr>
     * </table>
     *
     * @param value A string representing either a German or UK / US numerical value.
     *
     * @return The corresponding representation by exchanging <code class ="myRed">'.'</code> and
     *          <code class="myGreen">','</code>.
     *
     * <br>
     * <section>
     *     <h4>Hint:</h4>
     *     <p>{@link String#toCharArray()} allows for processing each character individually.</p>
     * </section>
     */
    public static String switchDecimal(final String value) {
        final StringBuilder RESULT = new StringBuilder();
        for (final char CH: value.toCharArray()) {
            RESULT.append(switch (CH) {
                case '.' -> ',';
                case ',' -> '.';
                default ->  CH;
            });
        }
        return RESULT.toString();
    }

    private StringHelper() {/* Ignore me: My sole purpose is suppressing default constructor javadoc generation */}
}
