package de.hdm_stuttgart.mi.sd1.task1;

/**
 * Attending courses.
 */
public class Course {

    /**
     * <p>Success or failure attending a given course.</p>
     *
     * <p>We assume a grading system ranging from 1 / perfect to 6 / insufficient. A course has been attended
     *    successfully if at least either of two conditions holds:</p>
     *
     * <ul>
     *     <li>The written examination's <code>examGrade</code> is 4 or better.</li>
     *
     *     <li>The <code>oralGrade</code> is 5 or better and the <code>courseAttendance</code> rate is at least 80 %.</li>
     * </ul>
     *
     * @param examGrade The examination result ranging from 1 / »perfect« to 6 / insufficient«.
     * @param oralGrade The oral grade result ranging from 1 / »perfect« to 6 / insufficient«.
     * @param courseAttendance Course participation ranging from 0 % (»completely absent«)
     *                         to 100 % (»always present«).
     * @return <code>true</code> if course has been attended successfully, <code>false</code> otherwise.
     */
    public static boolean wasSuccessful(int examGrade, int oralGrade, int courseAttendance) {
        return examGrade <= 4 || (oralGrade <= 5 && 80 <= courseAttendance);
    }

    private Course() {/* Ignore me: My sole purpose is suppressing default constructor javadoc warnings */}
}
